[indent=2]

class GLWindow : Gtk.Window
  def on_configure_event (widget : Gtk.Widget, event : Gdk.EventConfigure) : bool
    glcontext : Gdk.GLContext;
    gldrawable : Gdk.GLDrawable;

    glcontext = Gtk.WidgetGL.get_gl_context (widget)
    gldrawable = Gtk.WidgetGL.get_gl_drawable (widget)
    if (gldrawable.gl_begin (glcontext))
      GL.glViewport (0, 0, (GL.GLsizei)widget.allocation.width,
        (GL.GLsizei)widget.allocation.height)
      gldrawable.gl_end ()
      return true
    else
      return false

  def on_expose_event (widget : Gtk.Widget, event : Gdk.EventExpose) : bool
    glcontext : Gdk.GLContext;
    gldrawable : Gdk.GLDrawable;

    glcontext = Gtk.WidgetGL.get_gl_context (widget)
    gldrawable = Gtk.WidgetGL.get_gl_drawable (widget)
    if (gldrawable.gl_begin (glcontext))
      GL.glClear (GL.GL_COLOR_BUFFER_BIT)
      GL.glBegin (GL.GL_TRIANGLES)
      GL.glIndexi (0)
      GL.glColor3f (1.0f, 0.0f, 0.0f)
      GL.glVertex2i (0, 1)
      GL.glIndexi (0)
      GL.glColor3f (0.0f, 1.0f, 0.0f)
      GL.glVertex2i (-1, -1)
      GL.glIndexi (0)
      GL.glColor3f (0.0f, 0.0f, 1.0f)
      GL.glVertex2i (1, -1)
      GL.glEnd ()

      if (gldrawable.is_double_buffered ())
        gldrawable.swap_buffers ()
      else
        GL.glFlush ()

      gldrawable.gl_end ()
      return true
    else
      return false

  init
    glconfig : Gdk.GLConfig;
    drawing_area : Gtk.DrawingArea;

    this.title = "simple"
    this.set_reallocate_redraws (true)
    this.destroy.connect (Gtk.main_quit)

    glconfig = new Gdk.GLConfig.by_mode (Gdk.GLConfigMode.RGB | Gdk.GLConfigMode.DOUBLE)

    drawing_area = new Gtk.DrawingArea ()
    drawing_area.set_size_request (200, 200)

    Gtk.WidgetGL.set_gl_capability (drawing_area, glconfig, null, true,
      Gdk.GLRenderType.RGBA_TYPE)

    drawing_area.configure_event.connect (this.on_configure_event);
    drawing_area.expose_event.connect (this.on_expose_event);

    this.add (drawing_area)

init
  Gtk.init (ref args)
  Gtk.gl_init (ref args)

  new GLWindow ().show_all ()

  Gtk.main ()

