#! /usr/bin/env python
# encoding: UTF-8
# Nicolas Joseph 2010

# @bug https://bugzilla.gnome.org/show_bug.cgi?id=612336

import os
import Task, Utils
from TaskGen import before, extension
from Logs import debug, warn, error

XSLTPROC_STR = '${XSLTPROC}'

class gtkbuilder_task(Task.Task):

  vars = ['XSLTPROC']
  color = 'BLUE'
  before = 'vala'
  quiet = True

  input = ''
  output = ''

  def run(self):
    cmd = [Utils.subst_vars(XSLTPROC_STR, self.env)]
    cmd.append ('-nodtdattr')

    namespace = self.env['namespace']
    cmd.append ('--stringparam \'namespace\' \'%s\'' % namespace)

    filename = self.input.change_ext('')
    class_name = ''.join([x.capitalize() for x in filename.name.split('-')])
    cmd.append ('--stringparam \'class-name\' \'%s\'' % class_name)

    cmd.append ('../gen-vala-gtk-widget-bindings.xslt')
    cmd.append ('%s' % self.input.srcpath (self.env))
    cmd.append ('> %s' % self.output.bldpath (self.env))
    return self.generator.bld.exec_command(' '.join(cmd))

@extension('.ui')
def gtkbuilder_file(self, node):
  task = self.create_task('gtkbuilder')
  task.input = node
  task.output = node.change_ext('.vala')

def detect(conf):
  conf.find_program('xsltproc', var='XSLTPROC', mandatory=True)

