/* document-new-dialog.vala
 *
 * Copyright (C) 2012 Manuel Bachmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Manuel Bachmann <tarnyko@tarnyko.net>
 */

/**
 * DocumentNewDialog is a dialog box that displays an entry to type
 * the name of the new document to create
 */
public class Valide.DocumentNewDialog : Gtk.Dialog
{
  private Gtk.Label label;
  public Gtk.Entry entry;
  private Gtk.HSeparator hseparator;
  private Gtk.HBox buttons_hbox;
  private Gtk.Image ok_button_image;
  private Gtk.Image cancel_button_image;
  private Gtk.Label ok_button_label;
  private Gtk.Label cancel_button_label;
  private Gtk.HBox ok_button_hbox;
  private Gtk.HBox cancel_button_hbox;
  private Gtk.Button ok_button;
  private Gtk.Button cancel_button;

  /**
   * Create a new Valide.DocumentNewDialog
   */
  public DocumentNewDialog (Document document)
  {
    this.title = "Create new file...";
    this.icon = this.render_icon (Gtk.Stock.NEW, Gtk.IconSize.SMALL_TOOLBAR, null);
    this.set_modal (true);
    this.has_separator = false;

    label = new Gtk.Label ("File name :");
    entry = new Gtk.Entry ();
    hseparator = new Gtk.HSeparator ();
    buttons_hbox = new Gtk.HBox (true,5);
    ok_button_image = new Gtk.Image.from_stock (Gtk.Stock.APPLY, Gtk.IconSize.SMALL_TOOLBAR);
    ok_button_label = new Gtk.Label ("OK");
    ok_button_hbox = new Gtk.HBox (false,0);
    ok_button = new Gtk.Button ();
    cancel_button_image = new Gtk.Image.from_stock (Gtk.Stock.CANCEL, Gtk.IconSize.SMALL_TOOLBAR);
    cancel_button_label = new Gtk.Label ("Cancel");
    cancel_button_hbox = new Gtk.HBox (false,0);
    cancel_button = new Gtk.Button ();

    ok_button_hbox.add (ok_button_image);
    ok_button_hbox.add (ok_button_label);
    ok_button.add (ok_button_hbox);
    cancel_button_hbox.add (cancel_button_image);
    cancel_button_hbox.add (cancel_button_label);
    cancel_button.add (cancel_button_hbox);
    buttons_hbox.add (ok_button);
    buttons_hbox.add (cancel_button);
    this.vbox.add (label);
    this.vbox.add (entry);
    this.vbox.add (hseparator);
    this.vbox.add (buttons_hbox);
    this.vbox.set_spacing (5);

    this.show_all ();

     /* events */
    entry.activate.connect (() => {
        if (entry.text.replace (".vala","").strip () != "")
        {
             document.path = entry.text;
	     this.destroy ();
        }
    });

    ok_button.clicked.connect (() => {
        if (entry.text.replace (".vala","").strip () != "")
        {
             document.path = entry.text;
	     this.destroy ();
        }
    });

    cancel_button.clicked.connect (() => {
        document.path = "";
	this.destroy ();
    });

    this.delete_event.connect (() => {
        document.path = "";
        this.destroy ();
	 return true;
    });

    entry.insert_text.connect (restrict_chars);
  }

  public void restrict_chars (string text, int length, void* position)
  {
       if ( (text.contains ("/"))||(text.contains ("\\"))||(text.contains (":"))||(text.contains ("*"))||(text.contains ("?"))||(text.contains ("\""))||(text.contains ("<"))||(text.contains (">")) )
       {
        Signal.stop_emission_by_name (entry, "insert-text");
        Gdk.beep ();
       }
  }

}