/* split-source-view.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 *   Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/**
 * A widget with two Valide.SourceView with the same buffer
 */
public class Valide.SplitSourceView : Gtk.HPaned
{
  private SourceView view1;
  private SourceView view2;
  private unowned SourceView last_active;

  public signal void search ();
  public signal void find_next ();
  public signal void find_prev ();
  public signal void replace ();

  /**
   * The view is split
   */
  public bool is_split
  {
    get;
    private set;
  }

  /**
   * @see Gtk.SourceView.right_margin_position
   */
  public uint right_margin_position
  {
    get
    {
      return this.view1.get_right_margin_position ();
    }
    set
    {
      this.view1.set_right_margin_position (value);
      this.view2.set_right_margin_position (value);
    }
  }

  /**
   * @see Gtk.SourceView.show_right_margin
   */
  public bool show_right_margin
  {
    get
    {
      return this.view1.get_show_right_margin ();
    }
    set
    {
      this.view1.set_show_right_margin (value);
      this.view2.set_show_right_margin (value);
    }
  }

  /**
   * @see Gtk.SourceView.show_line_numbers
   */
  public bool show_line_numbers
  {
    get
    {
      return this.view1.get_show_line_numbers ();
    }
    set
    {
      this.view1.set_show_line_numbers (value);
      this.view2.set_show_line_numbers (value);
    }
  }

  /**
   * @see Gtk.SourceView.auto_indent
   */
  public bool auto_indent
  {
    get
    {
      return this.view1.get_auto_indent ();
    }
    set
    {
      this.view1.set_auto_indent (value);
      this.view2.set_auto_indent (value);
    }
  }

  /**
   * @see Gtk.SourceView.highlight_current_line
   */
  public bool highlight_current_line
  {
    get
    {
      return this.view1.get_highlight_current_line ();
    }
    set
    {
      this.view1.set_highlight_current_line (value);
      this.view2.set_highlight_current_line (value);
    }
  }

  /**
   * @see Gtk.SourceView.indent_on_tab
   */
  public bool indent_on_tab
  {
    get
    {
      return this.view1.get_indent_on_tab ();
    }
    set
    {
      this.view1.set_indent_on_tab (value);
      this.view2.set_indent_on_tab (value);
    }
  }

  /**
   * @see Gtk.SourceView.insert_spaces_instead_of_tabs
   */
  public bool insert_spaces_instead_of_tabs
  {
    get
    {
      return this.view1.get_insert_spaces_instead_of_tabs ();
    }
    set
    {
      this.view1.set_insert_spaces_instead_of_tabs (value);
      this.view2.set_insert_spaces_instead_of_tabs (value);
    }
  }

  /**
   * @see Gtk.SourceView.tab_width
   */
  public uint tab_width
  {
    get
    {
      return this.view1.get_tab_width ();
    }
    set
    {
      this.view1.set_tab_width (value);
      this.view2.set_tab_width (value);
    }
  }

  /**
   * The text font
   */
  public string font
  {
    set
    {
      this.view1.font = value;
      this.view2.font = value;
    }
  }

  /**
   * The style scheme
   */
  public string style_scheme
  {
    set
    {
      this.view1.style_scheme = value;
    }
  }

  public bool draw_spaces_space
  {
    get
    {
      return this.view1.draw_spaces_space;
    }
    set
    {
      this.view1.draw_spaces_space = value;
      this.view2.draw_spaces_space = value;
    }
  }

  public bool draw_spaces_tab
  {
    get
    {
      return this.view1.draw_spaces_tab;
    }
    set
    {
      this.view1.draw_spaces_tab = value;
      this.view2.draw_spaces_tab = value;
    }
  }

  public bool draw_spaces_newline
  {
    get
    {
      return this.view1.draw_spaces_newline;
    }
    set
    {
      this.view1.draw_spaces_newline = value;
      this.view2.draw_spaces_newline = value;
    }
  }

  public bool draw_spaces_nbsp
  {
    get
    {
      return this.view1.draw_spaces_nbsp;
    }
    set
    {
      this.view1.draw_spaces_nbsp = value;
      this.view2.draw_spaces_nbsp = value;
    }
  }

  public bool draw_spaces_leading
  {
    get
    {
      return this.view1.draw_spaces_leading;
    }
    set
    {
      this.view1.draw_spaces_leading = value;
      this.view2.draw_spaces_leading = value;
    }
  }

  public bool draw_spaces_text
  {
    get
    {
      return this.view1.draw_spaces_text;
    }
    set
    {
      this.view1.draw_spaces_text = value;
      this.view2.draw_spaces_text = value;
    }
  }

  public bool draw_spaces_trailing
  {
    get
    {
      return this.view1.draw_spaces_trailing;
    }
    set
    {
      this.view1.draw_spaces_trailing = value;
      this.view2.draw_spaces_trailing = value;
    }
  }

  /**
   * @see Gtk.SourceView.smart_home_end
   */
  public string smart_home_end
  {
    get
    {
      return this.view1.smart_home_end;
    }
    set
    {
      this.view1.smart_home_end = value;
      this.view2.smart_home_end = value;
    }
  }

  /**
   * The currently active text view
   */
  public SourceView active_view
  {
    get
    {
      if (this.view2  == null)
      {
        return this.view1;
      }
      else
      {
        return this.last_active;
      }
    }
  }

  private bool focus_in_event_cb (Gtk.Widget sender, Gdk.EventFocus event)
  {
    this.last_active = sender as SourceView;
    return false;
  }

  construct
  {
    Gtk.ScrolledWindow scrolled_window;

    this.view1 = new SourceView ();
    this.view1.focus_in_event.connect (this.focus_in_event_cb);

    scrolled_window = new Gtk.ScrolledWindow (null, null);
    scrolled_window.set_policy (Gtk.PolicyType.AUTOMATIC, Gtk.PolicyType.AUTOMATIC);
    this.add1 (scrolled_window);
    scrolled_window.add (this.view1);

    this.last_active = this.view1;

    this.view2 = new SourceView ();
    this.view2.focus_in_event.connect (this.focus_in_event_cb);

    this.view2.buffer = this.view1.buffer;

    /* Signal wrapper */
    this.view1.key_press_event.connect ((s, e) => { return this.key_press_event (e); });
    this.view1.focus_out_event.connect ((s, e) => { return this.focus_out_event (e); });
    this.view1.button_press_event.connect ((s, e) => { return this.button_press_event (e); });
    this.view1.search.connect ((s) => { this.search (); });
    this.view1.find_next.connect ((s) => { this.find_next (); });
    this.view1.find_prev.connect ((s) => { this.find_prev (); });
    this.view1.replace.connect ((s) => { this.replace (); });

    this.view2.key_press_event.connect ((s, e) => { return this.key_press_event (e); });
    this.view2.focus_out_event.connect ((s, e) => { return this.focus_out_event (e); });
    this.view2.button_press_event.connect ((s, e) => { return this.button_press_event (e); });
    this.view2.search.connect ((s) => { this.search (); });
    this.view2.find_next.connect ((s) => { this.find_next (); });
    this.view2.find_prev.connect ((s) => { this.find_prev (); });
    this.view2.replace.connect ((s) => { this.replace (); });
  }

  /**
   * @see Gtk.TreeView.set_editable
   */
  public void set_editable (bool setting)
  {
    this.view1.set_editable (setting);
    this.view2.set_editable (setting);
  }

  /**
   * Split the document container
   */
  public void split ()
  {
    if (!this.is_split)
    {
      Gtk.ScrolledWindow scrolled_window;

      scrolled_window = new Gtk.ScrolledWindow (null, null);
      scrolled_window.set_policy (Gtk.PolicyType.AUTOMATIC, Gtk.PolicyType.AUTOMATIC);
      this.add2 (scrolled_window);
      scrolled_window.add (this.view2);

      scrolled_window.show_all ();
      this.is_split = true;
    }
  }

  /**
   * Unsplit the document container
   */
  public void unsplit ()
  {
    if (this.is_split)
    {
      this.remove (this.view2.get_parent ());
      this.is_split = false;
    }
  }
}

