/* aboutdialog.vala
 *
 * Copyright (C) 2008-2009  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

/*
 * This code is re-writing in the vala language of GeditStatusbar
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 * Copyright (C) 2007  Mathias Hasselmann
 */

/**
 * The status bar
 */
public class Valide.Statusbar : Gtk.Statusbar
{
  private Gtk.Statusbar cursor_position_statusbar;
  private uint flash_context_id;
  private uint flash_message_id;
  private uint flash_timeout;

  private bool remove_message_timeout ()
  {
	  this.remove (this.flash_context_id, this.flash_message_id);

	  /* remove the timeout */
	  this.flash_timeout = 0;
  	return false;
  }

  construct
  {
    base.set_has_resize_grip (false);

    this.cursor_position_statusbar = new Gtk.Statusbar ();
    this.cursor_position_statusbar.show ();
    this.cursor_position_statusbar.set_size_request (160, 10);
    this.cursor_position_statusbar.set_has_resize_grip (false);
    this.pack_end (this.cursor_position_statusbar, false, true, 0);
  }

  /**
   * @see Gtk.Statusbar.set_has_resize_grip
   */
  public new void set_has_resize_grip (bool show)
  {
    this.cursor_position_statusbar.set_has_resize_grip (show);
  }

  /**
   * Sets the cursor position on the statusbar.
   *
   * @param line Line position
   * @param col Column position
   */
  public void set_cursor_position (int line, int col)
  {
	  string msg;

	  this.cursor_position_statusbar.pop (0);

  	if (line != -1 || col != -1)
  	{
	    /* Translators: "Ln" is an abbreviation for "Line", Col is an abbreviation for "Column".
	    Please, use abbreviations if possible to avoid space problems. */
	    msg = _("  Ln %d, Col %d").printf (line, col);

	    this.cursor_position_statusbar.push (0, msg);
    }
  }

  /**
   * Flash a temporary message on the statusbar.
   *
   * @param context_id Message context_id
   * @param msg Message to flash on the statusbar
   */
  public void flash_message (uint context_id, string msg)
  {
  	uint32 flash_length = 3000; /* three seconds */

	  /* remove a currently ongoing flash message */
  	if (this.flash_timeout > 0)
	  {
		  GLib.Source.remove (this.flash_timeout);
		  this.flash_timeout = 0;

		  this.remove (this.flash_context_id, this.flash_message_id);
	  }

	  this.flash_context_id = context_id;
	  this.flash_message_id = this.push (context_id, msg);

	  this.flash_timeout = Timeout.add (flash_length, remove_message_timeout);
  }
}

