[CCode (cprefix = "Gtk", lower_case_cprefix = "gtk_")]
namespace Fix
{
  /* @bug https://bugzilla.gnome.org/show_bug.cgi?id=617963 */
  [CCode (cheader_filename = "gtk/gtk.h")]
  public struct AccelKey
  {
    public uint accel_flags;
    public uint accel_key;
    public Gdk.ModifierType accel_mods;
  }

  /* @bug https://bugzilla.gnome.org/show_bug.cgi?id=617962 */
  [CCode (cheader_filename = "gtk/gtk.h")]
  public class AccelMap : Gtk.AccelMap
  {
    public static bool lookup_entry (string accel_path, out AccelKey key);
  }
}

[CCode (cprefix = "G", lower_case_cprefix = "g_")]
namespace GFix
{
  /* @ bug https://bugzilla.gnome.org/show_bug.cgi?id=621317 */
  [Compact]
  [CCode (lower_case_csuffix = "type_module", unref_function = "")]
  public abstract class TypeModule : GLib.Object, GLib.TypePlugin
  {
    public bool use ();
    public void unuse ();
    public void set_name (string name);
    [NoWrapper]
    public abstract bool load ();
    [NoWrapper]
    public abstract void unload ();
  }
}

