/* kill.c
 *
 * Copyright (C) 2008-2009  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

#include "kill.h"

#ifdef G_OS_UNIX
#  ifndef _POSIX_C_SOURCE
#    define _POSIX_C_SOURCE
#  endif /* not _POSIX_C_SOURCE */
#  include <sys/types.h>
#  include <signal.h>
#else
#  ifdef G_OS_WIN32
/** @bug http://code.google.com/p/waf/issues/detail?id=212 */
#    undef DATADIR
#    include <windows.h>
#  else
#    error Kill not implemented for this OS.
#  endif /* G_OS_WIN32 */
#endif /* G_OS_UNIX */

void pid_kill (GPid pid)
{
#ifdef G_OS_UNIX
  kill ((pid_t)pid, SIGKILL);
#else
#  ifdef G_OS_WIN32
  TerminateProcess ((HANDLE)pid, 0);
#  endif /* G_OS_WIN32 */
#endif /* G_OS_UNIX */
}
