/* advanced-search-dialog.vala
 *
 * Copyright (C) 2010  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

using Valide;

public class AdvancedSearchDialog : Gtk.Dialog
{
  private Gtk.Entry entry;
  private Gtk.CheckButton check_case;
  private Gtk.CheckButton check_entire;
  private Gtk.CheckButton check_regex;
  private Gtk.RadioButton radio_current;
  private Gtk.RadioButton radio_opened;
  private Gtk.RadioButton radio_project;

  public bool case_sensitive
  {
    get { return this.check_case.active; }
  }

  public bool entire_word
  {
    get { return this.check_entire.active; }
  }

  public bool use_regex
  {
    get { return this.check_regex.active; }
  }

  public string pattern
  {
    get { return this.entry.get_text (); }
  }

  public bool current_scope
  {
    get { return this.radio_current.active; }
  }

  public bool opened_scope
  {
    get { return this.radio_opened.active; }
  }

  public bool project_scope
  {
    get { return this.radio_project.active; }
  }

  public bool active_current_scope
  {
    get { return this.radio_current.sensitive; }
    set
    {
      this.radio_current.sensitive = value;
      if (!value && this.radio_current.active)
      {
        this.radio_project.active = true;
      }
    }
  }

  public bool active_opened_scope
  {
    get { return this.radio_opened.sensitive; }
    set
    {
      this.radio_opened.sensitive = value;
      if (!value && this.radio_opened.active)
      {
        if (this.active_current_scope)
        {
          this.radio_current.active = false;
        }
        else
        {
          this.radio_project.active = false;
        }
      }
    }
  }

  public bool active_project_scope
  {
    get { return this.radio_project.sensitive; }
    set
    {
      this.radio_project.sensitive = value;
      if (!value && this.radio_project.active)
      {
        this.radio_current.active = true;
      }
    }
  }

  construct
  {
    Frame frame;
    Gtk.VBox vbox;
    Gtk.HBox hbox;
    Gtk.Label label;
    Gtk.Widget widget;

    this.set_border_width (5);
    this.vbox.spacing = 10;
    this.set_default_response (Gtk.ResponseType.ACCEPT);

    this.title = _("Advanced search");
    this.add_button (Gtk.Stock.CANCEL, Gtk.ResponseType.CANCEL);
    widget = this.add_button (Gtk.Stock.FIND, Gtk.ResponseType.ACCEPT);
    widget.grab_default ();

    hbox = new Gtk.HBox (false, 5);
    this.vbox.pack_start (hbox, false, true, 0);

    label = new Gtk.Label (_("Search:"));
    hbox.pack_start (label, false, false, 0);

    this.entry = new Gtk.Entry ();
    this.entry.set_activates_default (true);
    hbox.pack_start (this.entry, true, true, 0);

    hbox = new Gtk.HBox (false, 5);
    this.vbox.pack_start (hbox, false, true, 0);

    frame = new Frame (_("Options"));
    hbox.pack_start (frame, false, true, 0);

    vbox = new Gtk.VBox (true, 0);
    frame.add (vbox);

    this.check_case = new Gtk.CheckButton.with_label (_("Match case"));
    vbox.pack_start (this.check_case, false, true, 0);

    this.check_entire = new Gtk.CheckButton.with_label (_("Match entire word only"));
    vbox.pack_start (this.check_entire, false, true, 0);

    this.check_regex = new Gtk.CheckButton.with_label (_("Use regular expression"));
    vbox.pack_start (this.check_regex, false, true, 0);

    frame = new Frame (_("Scope"));
    hbox.pack_start (frame, false, true, 0);

    vbox = new Gtk.VBox (true, 0);
    frame.add (vbox);

    this.radio_current = new Gtk.RadioButton.with_label (null, _("Current file"));
    vbox.pack_start (this.radio_current, false, true, 0);

    this.radio_opened = new Gtk.RadioButton.with_label_from_widget (this.radio_current, _("All opened files"));
    vbox.pack_start (this.radio_opened, false, true, 0);

    this.radio_project = new Gtk.RadioButton.with_label_from_widget (this.radio_current, _("All project files"));
    vbox.pack_start (this.radio_project, false, true, 0);
  }
}

