/* configure-executable.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

using Valide;

public class ConfigureExecutable : Executable
{
  private static const string EXECUTABLE_PATH = "./configure";
  /**
   * @see Valide.Executable.executable
   */
  public override string executable
  {
    get { return EXECUTABLE_PATH; }
    set {}
  }

  /**
   * @see Valide.Executable.get_color_line
   */
  public override void get_color_line (ref string line, out Gdk.Color color)
  {
    base.get_color_line (ref line, out color);
    if (line.has_suffix ("finished successfully"))
    {
      Gdk.Color.parse (Utils.Color.SUCCESS, out color);
    }
    else
    {
      if (line.has_suffix ("yes"))
      {
        Gdk.Color.parse (Utils.Color.SUCCESS, out color);
      }
      else if (line.has_suffix ("no"))
      {
        Gdk.Color.parse (Utils.Color.WARNING, out color);
      }
      else if (line.has_prefix ("configure: error:"))
      {
        Gdk.Color.parse (Utils.Color.ERROR, out color);
      }
    }
  }
}

