/* make-options.vala
 *
 * Copyright (C) 2008-2009  Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

public class Valide.MakeBuilderOptions : Object,
                                         BuilderOptions, GLib.YAML.Buildable
{
  /**
   * prefix installation
   */
  public string prefix { get; set; }

  public string configure_options { get; set; }
  public string build_options { get; set; }
  public string install_options { get; set; }
  public string dist_options { get; set; }
  public string clean_options { get; set; }
  public string distclean_options { get; set; }
  public string uninstall_options { get; set; }

  public string to_string (BuildingStep step)
  {
    StringBuilder sb;

    sb = new StringBuilder ("");
    switch (step)
    {
      case BuildingStep.CONFIGURE:
        if (this.prefix != null && this.prefix != "")
        {
          sb.append_printf ("--prefix='%s' ", this.prefix);
        }
        if (this.configure_options != null)
        {
          sb.append (this.configure_options);
        }
      break;
      case BuildingStep.BUILD:
        if (this.build_options != null)
        {
          sb.append (this.build_options);
        }
      break;
      case BuildingStep.INSTALL:
        sb.append ("install ");
        if (this.install_options != null)
        {
          sb.append (this.install_options);
        }
      break;
      case BuildingStep.DIST:
        sb.append ("dist ");
        if (this.dist_options != null)
        {
          sb.append (this.dist_options);
        }
      break;
      case BuildingStep.CLEAN:
        sb.append ("clean ");
        if (this.clean_options != null)
        {
          sb.append (this.clean_options);
        }
      break;
      case BuildingStep.DISTCLEAN:
        sb.append ("disclean ");
        if (this.distclean_options != null)
        {
          sb.append (this.distclean_options);
        }
      break;
      case BuildingStep.UNINSTALL:
        sb.append ("uninstall ");
        if (this.uninstall_options != null)
        {
          sb.append (this.uninstall_options);
        }
      break;
    }
    return sb.str;
  }
}

