/* waf-preferences.vala
 *
 * Copyright (C) 2008-2010 Nicolas Joseph
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author:
 * 	Nicolas Joseph <nicolas.joseph@valaide.org>
 */

using Valide;

public class WafBuilderPreferences : Gtk.Table
{
  private unowned WafBuilderOptions options;

  public Project project
  {
    get;
    construct;
  }

  public WafBuilderPreferences (Project project)
  {
    Object (project: project);
  }

  construct
  {
    Gtk.Label label;
    Gtk.Entry entry;

    this.resize (2, 9);
    this.set_border_width (5);
    this.set_col_spacings (5);
    this.set_row_spacings (10);
    this.options = this.project.builder_options as WafBuilderOptions;

    /* building dir */
    label = new Gtk.Label (_("Building directory:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 0, 1, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.build_dir != null)
    {
      entry.set_text (this.options.build_dir);
    }
    entry.changed.connect ((s) => {
      this.options.build_dir = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 0, 1, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* prefix */
    label = new Gtk.Label (_("Prefix:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 1, 2, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.prefix != null)
    {
      entry.set_text (this.options.prefix);
    }
    entry.changed.connect ((s) => {
      this.options.prefix = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 1, 2, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* configure_options */
    label = new Gtk.Label (_("Configure options:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 2, 3, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.configure_options != null)
    {
      entry.set_text (this.options.configure_options);
    }
    entry.changed.connect ((s) => {
      this.options.configure_options = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 2, 3, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* build_options */
    label = new Gtk.Label (_("Build options:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 3, 4, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.build_options != null)
    {
      entry.set_text (this.options.build_options);
    }
    entry.changed.connect ((s) => {
      this.options.build_options = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 3, 4, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* install_options */
    label = new Gtk.Label (_("Install options:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 4, 5, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.install_options != null)
    {
      entry.set_text (this.options.install_options);
    }
    entry.changed.connect ((s) => {
      this.options.install_options = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 4, 5, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* dist_options */
    label = new Gtk.Label (_("Dist options:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 5, 6, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.dist_options != null)
    {
      entry.set_text (this.options.dist_options);
    }
    entry.changed.connect ((s) => {
      this.options.dist_options = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 5, 6, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* clean_options */
    label = new Gtk.Label (_("Clean options:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 6, 7, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.clean_options != null)
    {
      entry.set_text (this.options.clean_options);
    }
    entry.changed.connect ((s) => {
      this.options.clean_options = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 6, 7, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* distclean_options */
    label = new Gtk.Label (_("Distclean options:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 7, 8, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.distclean_options != null)
    {
      entry.set_text (this.options.distclean_options);
    }
    entry.changed.connect ((s) => {
      this.options.distclean_options = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 7, 8, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

    /* uninstall_options */
    label = new Gtk.Label (_("Uninstall options:"));
    label.set_alignment (0.0f, 0.5f);
    this.attach (label, 0, 1, 8, 9, Gtk.AttachOptions.FILL, 0, 0, 0);

    entry = new Gtk.Entry ();
    if (this.options.uninstall_options != null)
    {
      entry.set_text (this.options.uninstall_options);
    }
    entry.changed.connect ((s) => {
      this.options.uninstall_options = (s as Gtk.Entry).get_text ();
      this.project.save ();
    });
    this.attach (entry, 1, 2, 8, 9, Gtk.AttachOptions.EXPAND | Gtk.AttachOptions.FILL, 0, 0, 0);

  }
}

